package pl.psnc.expres.remote.network.requester;

import java.util.concurrent.BlockingQueue;
import pl.psnc.expres.remote.network.executors.ExecutorException;
import pl.psnc.expres.remote.network.task.MeasurementTask;

/**
 * Class is responsible for invoking parallel measurement 
 * 
 * @author Lucas Dolata <ldolat@man.poznan.pl>
 *
 */
public class RequesterTask extends Thread {
	/**
	 * Queue with requested measurement tasks
	 */
	public BlockingQueue<MeasurementTask> queue;
	/**
	 * Observer of measurement life time 
	 */
	public RequesterObserver observer;
	
	
	public RequesterTask (BlockingQueue<MeasurementTask> queue){
		this.queue= queue;
	}
    
	public void run() {
        MeasurementTask task;
        while (true) {
					try {
						task = (MeasurementTask) queue.take();
						if (task !=null){
							try {
								task.execute();
								observer.taskComplete(task);
							} catch (ExecutorException e) {
								observer.taskFailed (task);
							}
							
						}
					} catch (InterruptedException e) {
							Thread.currentThread().interrupt();
					}
					
					
                
        }
    }
}