package pl.psnc.expres.remote.network.requester;

import pl.psnc.expres.remote.network.task.MeasurementTask;
/**
 * Interface for notifying if task is completed or failed
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public interface RequesterObserver {
	/**
	 * Notifies if task is completed
	 * 
	 * @param task completed task
	 */
	public void taskComplete (MeasurementTask task);
	/**
	 * Notifies if task failed
	 * 
	 * @param task failed task
	 */
	public void taskFailed (MeasurementTask task);
}
