package pl.psnc.expres.remote.network.requester;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import pl.psnc.expres.remote.network.task.MeasurementTask;

/**
 * Class is use for invoking parallel measurements queries. It uses the  collection
 * of thread Requesters  
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class Requester {
		/**Concurrent working thread */
	    private RequesterTask[] requesters;
	    
	    /**List of task to do*/
	    private final BlockingQueue<MeasurementTask> queue = new LinkedBlockingQueue<MeasurementTask>();
	    
	    /**Observer use to notify task completness*/
	    private RequesterObserver observer;
	    
	   /** Number of concurrent tasks*/
	    private int numberOfRequesters;
	    
	    /**
	     * Initilizes and starts requester module
	     */
	    public void start () {
	    	requesters = new RequesterTask[numberOfRequesters];
	    	for (int i=0; i<numberOfRequesters; i++) {
	            requesters[i] = new RequesterTask(queue);
	            requesters[i].start();
	        }
	    }
	    public boolean execute(MeasurementTask task) {
	    	return queue.add(task);
	    }
	    
	    public RequesterObserver getObserver() {
			return observer;
		}
		public void setObserver(RequesterObserver observer) {
			this.observer = observer;
		}
		public int getNumberOfRequesters() {
			return numberOfRequesters;
		}
		public void setNumberOfRequesters(int numberOfRequesters) {
			this.numberOfRequesters = numberOfRequesters;
		}
		
}



