package pl.psnc.expres.remote.network.parsers;

import java.util.Map;
import org.w3c.dom.Document;
import pl.psnc.expres.model.resource.ResourceValue;

/**
 * Interface used for parsing different types request and measurement results 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public interface MessageParser {
	/**
	 * Creates request message in w3c document format
	 * 
	 * @param parameters parameters for request message
	 * @return
	 */
	public Document createRequestDocument (ResourceValue destination, Map<String,String>parameters) throws ParserException;
	/**
	 * Creates request message in string format
	 * 
	 * @param parameters parameters for request message
	 * @return
	 */
	public String createRequestString (ResourceValue destination, Map<String,String>parameters) throws ParserException;
	
	/**
	 * Decodes result message in document format
	 * 
	 * @param document document message
	 * @return map with result values
	 */
	public void decodeMessageDocument (Document document, Map<String, Object> resultMap) throws ParserException;
	/**
	 * Decodes message in string format
	 * 
	 * @param document document with NMWG message
	 * @return
	 */
	public void decodeMessageString (String result, Map<String, Object> resultMap) throws ParserException;
	/**
	 * Loads xml templates and default parameters
	 * 
	 * @param path path to directory where template can be found
	 * @throws ParserInitException
	 */
	public void init (String path) throws ParserException;
}
