package pl.psnc.expres.remote.network.executors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Class is responsible for creating and getting 
 *
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 */
public class ExecutorsFactory {
	
	public Map<String, Executor> getExecutors() {
		return executors;
	}

	public void setExecutors(Map<String, Executor> executors) {
		this.executors = executors;
	}

	/**Stores different types of executors*/
	Map <String, Executor> executors = new HashMap<String, Executor>();
	
	/**Logs all information */
	Log logger = LogFactory.getLog(ExecutorsFactory.class);
	
	/**
	 * Get executor by name
	 * @param name	name of executor
	 * @return null if executor not exist
	 */
	public Executor getExecutor (String name){
		if (name != null)
			return executors.get(name);
		else
			return null;
	}
	
	public void init(){
		Executor executor;
		for (String name: executors.keySet()){
			executor = executors.get(name);
			if (executor== null)
				executors.remove(name);
			try {
				executor.init();
			} catch (ExecutorException e) {
					executors.remove(name);
					logger.error ("Unable to initialize executor:"+name+":"+e.getClass().getName()+":"+e.getMessage());
			}
		}
	}
}
