/**
 * Created on Sep 3, 2008
 */
package pl.psnc.expres.remote.network;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import pl.psnc.expres.remote.network.value.NetworkMetric;

/**
 * {@link INetworkMonitor} interface - defines an interface between Vlbi Broker
 * and EXPReS Network Monitor (ENM). This interface is used to request network
 * metrics and find best connection match-up between translation node (TN) and
 * file servers (FS).
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @author <a href="mailto:ldolata@man.poznan.pl">Lucas Dolata</a>
 * @email osa@man.poznan.pl
 * 
 */
@WebService (targetNamespace = "http://network.remote.expres.psnc.pl/", name = "INetworkMonitor")
public interface INetworkMonitor {

	/**
	 * Creates a new network metric order. This order will be processed by the
	 * EXPReS Network Module (ENM).
	 * 
	 * @param translationNodes list of translation nodes identifiers
	 * @param fileServers list of file servers identifiers
	 * @return metric order identifier
	 */
	@WebMethod(operationName="orderNetworkMetric")
	public int orderNetworkMetric(@WebParam(targetNamespace = "", name = "translationNodes")
			List<Integer> translationNodes, 
			@WebParam(targetNamespace = "", name = "fileServers")List<Integer> fileServers, 
			@WebParam(targetNamespace = "", name = "bandwidth_bytes") long bandwidth_bytes);

	/**
	 * Adds new network metric observer. Whenever new network order with the
	 * given order identifier is ready, the given observer is notified.
	 * 
	 * @param networkOrderId identifier of the network metric
	 * @param location location of observer
	 */
	@WebMethod(operationName="addObserver")
	public void addObserver(@WebParam(targetNamespace = "", name = "networkOrderId") int networkOrderId, 
			@WebParam(targetNamespace = "", name = "location")String location);

	/**
	 * Get network metric by the specified network order identifier.
	 * 
	 * @param networkOrderId identifier of the network metrics
	 * @return network metric or <code>NULL</code> if network metric is not
	 *         ready yet.
	 */
	@WebMethod(operationName="getNetworkMetric")
	public List<NetworkMetric> getNetworkMetric(@WebParam(targetNamespace = "", name = "networkOrderId")int networkOrderId);

}