/**
 * ResourceType.java
 * Created on Nov 9, 2007, 1:32:06 PM
 */
package pl.psnc.expres.model.type;

import pl.psnc.graph.model.type.AbstractResourceType;

/**
 * {@link ResourceType} class - class describing resource type
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class ResourceType extends AbstractResourceType {

	/** Stores instance of field: decorator */
	private ResourceTypeDecorator decorator;

	/**
	 * Creates a new instance of {@link ResourceType}
	 */
	public ResourceType() {
	}

	/**
	 * Creates a new instance of {@link ResourceType}
	 * 
	 * @param rawResourceType instance of {@link ResourceType}
	 */
	public ResourceType(ResourceType rawResourceType) {
		if (rawResourceType == null) {
			return;
		}
		setId(rawResourceType.getId());
		setClassName(rawResourceType.getClassName());
		setDescription(rawResourceType.getDescription());
		setName(rawResourceType.getName());
		this.decorator = rawResourceType.getDecorator();
	}

	// -----------------------------------------------------------------
	// ---- Parent class methods

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.graph.model.type.ResourceTypeDecorator#getIcon()
	 */
	public String getIcon() {
		return getDecorator().getIcon();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.graph.model.type.ResourceTypeDecorator#getImage()
	 */
	public String getImage() {
		return getDecorator().getImage();
	}

	// -----------------------------------------------------------------
	// ---- Setters/Getters

	/**
	 * Get value of field: decorator
	 * 
	 * @return the decorator
	 */
	public ResourceTypeDecorator getDecorator() {
		return decorator;
	}

	/**
	 * Set value of field: decorator
	 * 
	 * @param decorator the decorator to set
	 */
	public void setDecorator(ResourceTypeDecorator decorator) {
		this.decorator = decorator;
	}

}
