/**
 * ResourceLinksFactory.java
 * Created on Nov 8, 2007, 3:42:13 PM
 */
package pl.psnc.expres.model.factory;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.factory.helper.ModelKeys;
import pl.psnc.expres.model.link.LinkMapper;
import pl.psnc.expres.model.link.LinkValue;
import pl.psnc.expres.model.util.JsonReaderHelper;
import pl.psnc.vlab.exception.ResourceNotFoundException;

/**
 * The {@link ResourceLinksFactory} class - Links Factory is used to get the
 * list of links.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class ResourceLinksFactory {

	/** Logger instance */
	private static Log log = LogFactory.getLog(ResourceLinksFactory.class.getName());

	/** Stores the list of link's values */
	private static List<LinkValue> links;

	/**
	 * Get the resource link by the given id
	 * 
	 * @param id resource identifier
	 * @throws ResourceNotFoundException thrown if no resource is found
	 * @return resource link value object
	 */
	public static LinkValue getResourceLink(int id) throws ResourceNotFoundException {
		return getResourceLink(id, ModelKeys.LINK_LOCATION);
	}

	/**
	 * Get the resource link by the given id
	 * 
	 * @param id resource link id
	 * @param filePath path to a Json file with resource links description
	 * @return resource link value object
	 */
	public static LinkValue getResourceLink(int id, String filePath)
			throws ResourceNotFoundException {
		if (links == null) {
			links = getResourceLinks(filePath);
		}
		for (LinkValue linkValue : links) {
			if (linkValue.getId() == id) {
				return linkValue;
			}
		}
		throw new ResourceNotFoundException("Resource link [link id=" + id
				+ "] has not been found.");
	}

	/**
	 * Get the resource links from the given file
	 * 
	 * @param filePath path to a Json file with resource links description
	 * @return array with resource links value objects
	 */
	public static List<LinkValue> getResourceLinks(String filePath)
			throws ResourceNotFoundException {
		if (links == null) {
			Object res = JsonReaderHelper.load(filePath, LinkMapper.class);
			if (res == null) {
				log.error("getResourceLinks are NULL");
				return null;
			}
			links = Arrays.asList(((LinkMapper) res).getLinks());
		}
		return links;
	}

}
