/**
 * Created on Jul 23, 2008
 */
package pl.psnc.expres.remote.broker.impl;

import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.FileReader;

import javax.activation.DataHandler;

import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;

import pl.psnc.expres.remote.broker.xsd.RemoteVlbiExperiment;
import pl.psnc.expres.remote.broker.xsd.StartVlbiExperiment;
import pl.psnc.expres.remote.vex2ccf.Vex2CcfStub;
import pl.psnc.vlab.util.FileTools;

/**
 * {@link SubmitVlbiExperimentStubTest} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
@SuppressWarnings( { "unused", "unchecked" })
public class SubmitVlbiExperimentStubTest {

	/** Stores instance of field: log */
	private Log log = LogFactory.getLog(SubmitVlbiExperimentStubTest.class);

	/** Stores instance of field: stub */
	private SubmitVlbiExperimentStub stub;

	/** Stores instance of field: newVlbiExperiment */
	private StartVlbiExperiment newVlbiExperiment;

	/** Stores instance of field: vexFile */
	private String vexFile;

	@Before
	public void setUp() throws Exception {

		stub = new SubmitVlbiExperimentStub();

		newVlbiExperiment = new StartVlbiExperiment();
		RemoteVlbiExperiment remoteVlbiExperiment = new RemoteVlbiExperiment();

		String ccf = getCCFFile();
		byte res[] = ccf != null ? ccf.getBytes() : "NO ccf file defined.".getBytes();
		// remoteVlbiExperiment.setCcf(new DataHandler(new
		// ByteArrayDataSource(res)));

		remoteVlbiExperiment.setConnections(new DataHandler(new ByteArrayDataSource(
				"No connections ...".getBytes())));

		vexFile = getVexFile();
		res = vexFile != null ? vexFile.getBytes() : "No vex file.".getBytes();
		remoteVlbiExperiment.setVex(new DataHandler(new ByteArrayDataSource(res)));

		String experiment = getExperiment();
		res = experiment != null ? experiment.getBytes() : "No experiment description".getBytes();
		remoteVlbiExperiment.setVlbiExperiment(new DataHandler(new ByteArrayDataSource(res)));

		newVlbiExperiment.setParam0(remoteVlbiExperiment);

	}

	/**
	 * Test method for
	 * {@link pl.psnc.expres.wfm.remote.vlbi.experiment.SubmitVlbiExperimentStub#newVlbiExperiment(pl.psnc.expres.wfm.remote.vlbi.experiment.SubmitVlbiExperimentStub.StartVlbiExperiment)}.
	 */
	@Test
	public void testNewVlbiExperiment() {
		try {
			log.debug("<testNewVlbiExperiment>");
			stub.startVlbiExperiment(newVlbiExperiment);

		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}

	private String getCcf() throws Exception {
		// Vex2CcfStub vexStub = new Vex2CcfStub("http://melisa:1234/vex2ccf");
		Vex2CcfStub vexStub = new Vex2CcfStub("http://192.42.120.69:8081/vex2ccf");
		Vex2CcfStub.ConvertRequest convertRequest = new Vex2CcfStub.ConvertRequest();

		convertRequest.setVex_file(vexFile);
		Vex2CcfStub.ConvertResponse resp = vexStub.convert(convertRequest);
		return resp.getCcf_file();
	}

	private String getCCFFile() throws Exception {
		BufferedReader vexReader = new BufferedReader(new FileReader("build/model/ccf-sample.json"));
		String line = null;
		StringBuffer res = new StringBuffer();
		while ((line = vexReader.readLine()) != null) {
			res.append(line).append(FileTools.LINE_SEPARATOR);
		}
		vexReader.close();
		return res.toString();
	}

	private String getVexFile() throws Exception {
		BufferedReader vexReader = new BufferedReader(new FileReader("resources/n06c2.vix"));
		String line = null;
		StringBuffer res = new StringBuffer();
		while ((line = vexReader.readLine()) != null) {
			res.append(line).append(FileTools.LINE_SEPARATOR);
		}
		vexReader.close();
		return res.toString();
	}

	private String getExperiment() throws Exception {
		BufferedReader vexReader = new BufferedReader(new FileReader(
				"build/model/vlbiExperiment.json"));
		String line = null;
		StringBuffer res = new StringBuffer();
		while ((line = vexReader.readLine()) != null) {
			res.append(line).append(FileTools.LINE_SEPARATOR);
		}
		vexReader.close();
		return res.toString();
	}

}
