package pl.psnc.expres.model.factory;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Before;
import org.junit.Test;

import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.vlab.exception.ResourceNotFoundException;

public class ResourceFactoryTest {

	/** Stores instance of field: RESOURCE */
	private final String RESOURCE = "{\"resources\":[{\"id\":100,\"typeId\":100,\"abbreviation\": \"Tr\",\"name\":\"Torun - RT4\",\"description\":	\"RT4 Torun Radio telescope - 32 meters\"}]}";

	@Before
	public void setUp() throws Exception {
	}

	@Test
	public void testGetResourcesFromString() {
		try {
			List<ResourceValue> resourcesFromString = ResourceFactory.getResourcesFromString(RESOURCE);
			assertEquals(1, resourcesFromString != null ? resourcesFromString.size() : 0);
			assertEquals("Tr", resourcesFromString != null ? resourcesFromString.get(0).getAbbreviation() : null);
		} catch (ResourceNotFoundException e) {
			fail(e.getLocalizedMessage());
		}
	}

}
