package pl.psnc.expres.model.factory;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.FileReader;

import org.junit.Before;
import org.junit.Test;

import pl.psnc.expres.remote.vex2ccf.model.CCFValue;
import pl.psnc.vlab.util.FileTools;

public class CcfFactoryTest {

	private String ccf;

	@Before
	public void setUp() throws Exception {
		ccf = getCCFFile();
	}

	@Test
	public void testGetCcfModelString() {

		try {
			CCFValue ccfModel = CcfFactory.getCcfModel(ccf);
			assertEquals("N06C2", ccfModel.getExper_name());

		} catch (Exception e) {
			fail(e.getMessage());
		}

	}

	private String getCCFFile() throws Exception {
		BufferedReader vexReader = new BufferedReader(new FileReader("build/model/ccf-sample.json"));
		String line = null;
		StringBuffer res = new StringBuffer();
		while ((line = vexReader.readLine()) != null) {
			res.append(line).append(FileTools.LINE_SEPARATOR);
		}
		vexReader.close();
		return res.toString();
	}
}
