/**
 * Created on Sep 3, 2008
 */
package pl.psnc.expres.remote.network.value;

/**
 * {@link NetworkMetric} class - class represents network metric for pair of
 * translation node and file server.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class NetworkMetric {

	/** Stores instance of field: translation node Id */
	private int translationNodeId;

	/** Stores instance of field: file server Id */
	private int fileServerId;

	// TODO : add other networking parameters which can be displayed in the WFM,
	// like bandwidth, maybe some text description. TO BE DISCUSSED

	/**
	 * Creates a new instance of {@link NetworkMetric} with TN and FS
	 * identifiers defined.
	 * 
	 * @param translationNodeId translation node identifier
	 * @param fileServerId file server identifier
	 */
	public NetworkMetric(int translationNodeId, int fileServerId) {
		this.translationNodeId = translationNodeId;
		this.fileServerId = fileServerId;
	}

	// -----------------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of field: translationNodeId
	 * 
	 * @return the translationNodeId
	 */
	public int getTranslationNodeId() {
		return translationNodeId;
	}

	/**
	 * Set value of field: translationNodeId
	 * 
	 * @param translationNodeId the translationNodeId to set
	 */
	public void setTranslationNodeId(int translationNodeId) {
		this.translationNodeId = translationNodeId;
	}

	/**
	 * Get value of field: fileServerId
	 * 
	 * @return the fileServerId
	 */
	public int getFileServerId() {
		return fileServerId;
	}

	/**
	 * Set value of field: fileServerId
	 * 
	 * @param fileServerId the fileServerId to set
	 */
	public void setFileServerId(int fileServerId) {
		this.fileServerId = fileServerId;
	}

}
