package pl.psnc.expres.remote.correlation.value;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.i18n.ResourceBundleManager;

/**
 * {@link CorrelationState} enum - defines a set of possible states during
 * correlation. The enumeration name is internationalised.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public enum CorrelationState {

	// TODO Add the rest of states
	DATA_REDY("data.ready", "data.ready.desc");

	/** Stores name of bundle properties */
	private static final String BUNDLE = "bundle/correlationStates";

	/** Stores Logger instance */
	private static final Log log = LogFactory.getLog(CorrelationState.class);

	/** Stores enum name */
	private String name;

	/** Stores system text representation of this enum */
	private String description;

	/** Stores an instance of ResourceBundleFactory */
	private static ResourceBundleManager bundle;

	/**
	 * Creates new CorrelationState with internationalised name and description
	 * 
	 * @param nameKey name of the message key for this enum
	 * @param descriptionKey description key
	 */
	private CorrelationState(String nameKey, String descriptionKey) {
		this.name = getValue(nameKey);
		this.description = getValue(descriptionKey);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Enum#toString()
	 */
	@Override
	public String toString() {
		return this.name;
	}

	/**
	 * Get internationalised name of a correlation state
	 * 
	 * @return internationalised name of a correlation state
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * Get internationalised description of a correlation state
	 * 
	 * @return internationalised description of a correlation state
	 */
	public String getDescription() {
		return description;
	}

	// -------------------------------------------------------------------------
	// ---- Private Helper Methods

	/**
	 * Get instance of ResourceBundleManager
	 * 
	 * @return instance of ResourceBundleManager
	 */
	private static ResourceBundleManager getBundle() {
		if (bundle == null) {
			try {
				bundle = new ResourceBundleManager(BUNDLE);
			} catch (Exception e) {
				log.error(e.getMessage());
				return null;
			}
		}
		return bundle;
	}

	/**
	 * Get value for the given key
	 * 
	 * @param key key
	 * @return value for the given key
	 */
	private String getValue(String key) {
		ResourceBundleManager bundleManager = getBundle();
		if (bundleManager == null) {
			return key;
		}
		return bundle.getValue(key);
	}

}
