/**
 * JobInfo
 * Created on Jul 19, 2007
 */
package pl.psnc.expres.remote.broker.jobinfo;

/**
 * {@link TranslationJobInfo} class - used by the NewTranslationJob service to describe
 * translation job.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class TranslationJobInfo {

	/**
	 * The size of the data chunk. This value tells Translation Node how to
	 * divide data stream - it determines the length of data chunk
	 */
	private long chunkSize;

	/** Specifies the location of vlbi broker */
	private String brokerLocation;

	/**
	 * Specifies the location of grid ftp server, where data chunks will be
	 * stored
	 */
	private String gridFtpLocation;

	/** Specifies the start time of the experiment */
	private String startTime;

	/** Specifies the end time of the experiment */
	private String endTime;

	/** Experiment name */
	private String experimentName;

	/** Telescope name */
	private String telescopeName;

	// -----------------------------------------------------------------------------------
	// ---- Setters/Getters

	/**
	 * Get value of field: chunkSize
	 * 
	 * @return the chunkSize
	 */
	public long getChunkSize() {
		return chunkSize;
	}

	/**
	 * Set value of field: chunkSize
	 * 
	 * @param chunkSize the chunkSize to set
	 */
	public void setChunkSize(long chunkSize) {
		this.chunkSize = chunkSize;
	}

	/**
	 * Get value of field: brokerLocation
	 * 
	 * @return the brokerLocation
	 */
	public String getBrokerLocation() {
		return brokerLocation;
	}

	/**
	 * Set value of field: brokerLocation
	 * 
	 * @param brokerLocation the brokerLocation to set
	 */
	public void setBrokerLocation(String brokerLocation) {
		this.brokerLocation = brokerLocation;
	}

	/**
	 * Get value of field: gridFtpLocation
	 * 
	 * @return the gridFtpLocation
	 */
	public String getGridFtpLocation() {
		return gridFtpLocation;
	}

	/**
	 * Set value of field: gridFtpLocation
	 * 
	 * @param gridFtpLocation the gridFtpLocation to set
	 */
	public void setGridFtpLocation(String gridFtpLocation) {
		this.gridFtpLocation = gridFtpLocation;
	}

	/**
	 * Get value of field: startTime
	 * 
	 * @return the startTime
	 */
	public String getStartTime() {
		return startTime;
	}

	/**
	 * Set value of field: startTime
	 * 
	 * @param startTime the startTime to set
	 */
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	/**
	 * Get value of field: endTime
	 * 
	 * @return the endTime
	 */
	public String getEndTime() {
		return endTime;
	}

	/**
	 * Set value of field: endTime
	 * 
	 * @param endTime the endTime to set
	 */
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	/**
	 * Get value of field: experimentName
	 * 
	 * @return the experimentName
	 */
	public String getExperimentName() {
		return experimentName;
	}

	/**
	 * Set value of field: experimentName
	 * 
	 * @param experimentName the experimentName to set
	 */
	public void setExperimentName(String experimentName) {
		this.experimentName = experimentName;
	}

	/**
	 * Get value of field: telescopeName
	 * 
	 * @return the telescopeName
	 */
	public String getTelescopeName() {
		return telescopeName;
	}

	/**
	 * Set value of field: telescopeName
	 * 
	 * @param telescopeName the telescopeName to set
	 */
	public void setTelescopeName(String telescopeName) {
		this.telescopeName = telescopeName;
	}

}
