/*
 * ChunkInfo.java
 *
 * Created on June 01, 2007, 11:38 AM
 *
 */

package pl.psnc.expres.remote.broker.jobinfo;

/**
 * {@link ChunkInfo} class - used by the Translation Node Notification Service
 * to notify the Vlbi Broker that new data chunk is ready.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */

public class ChunkInfo {

	/**
	 * Translation node identifier
	 */
	private int translationNodeId;

	/**
	 * IP address of the translation node
	 */
	private String translationNodeIP;

	/**
	 * Identifier of the data chunk
	 */
	private long chunkId;

	/**
	 * Data chunk size
	 */
	private long chunkSize;

	/**
	 * Specifies location of the data chunk (URL)
	 */
	private String chunkLocation;

	/** Specifies the start time of the experiment */
	private String startTime;

	/** Specifies the end time of the experiment */
	private String endTime;

	// =================================================================
	// === Setters/Getters

	/**
	 * Getter for property ipAddress.
	 * 
	 * @return Value of property ipAddress.
	 */
	public String getTranslationNodeIP() {
		return this.translationNodeIP;
	}

	/**
	 * Setter for property ipAddress.
	 * 
	 * @param ipAddress New value of property ipAddress.
	 */
	public void setTranslationNodeIP(String translationNodeIP) {
		this.translationNodeIP = translationNodeIP;
	}

	/**
	 * Getter for property chunkId.
	 * 
	 * @return Value of property chunkId.
	 */
	public long getChunkId() {
		return this.chunkId;
	}

	/**
	 * Setter for property chunkId.
	 * 
	 * @param chunkId New value of property chunkId.
	 */
	public void setChunkId(long chunkId) {
		this.chunkId = chunkId;
	}

	/**
	 * Getter for property dataLocation.
	 * 
	 * @return Value of property dataLocation.
	 */
	public String getChunkLocation() {
		return this.chunkLocation;
	}

	/**
	 * Setter for property dataLocation.
	 * 
	 * @param dataLocation New value of property dataLocation.
	 */
	public void setChunkLocation(String chunkLocation) {
		this.chunkLocation = chunkLocation;
	}

	/**
	 * @return the translationNodeId
	 */
	public int getTranslationNodeId() {
		return translationNodeId;
	}

	/**
	 * @param translationNodeId the translationNodeId to set
	 */
	public void setTranslationNodeId(int translationNodeId) {
		this.translationNodeId = translationNodeId;
	}

	/**
	 * @return the chunkSize
	 */
	public long getChunkSize() {
		return chunkSize;
	}

	/**
	 * @param chunkSize the chunkSize to set
	 */
	public void setChunkSize(long chunkSize) {
		this.chunkSize = chunkSize;
	}

	/**
	 * @return the endTime
	 */
	public String getEndTime() {
		return endTime;
	}

	/**
	 * @param endTime the endTime to set
	 */
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	/**
	 * @return the startTime
	 */
	public String getStartTime() {
		return startTime;
	}

	/**
	 * @param startTime the startTime to set
	 */
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

}
