/**
 * ResourceTypeFactory.java
 * Created on Nov 8, 2007, 3:42:13 PM
 */
package pl.psnc.expres.model.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.util.JsonReaderHelper;
import pl.psnc.expres.remote.vex2ccf.model.CCFValue;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.FormTools;

/**
 * The {@link CcfFactory} class - used to create a CCF model from text
 * representation.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class CcfFactory {

	/** Logger instance */
	private static Log log = LogFactory.getLog(CcfFactory.class);

	/**
	 * Creates a CCF model from the given ccf file.
	 * 
	 * @param ccfContent ccf file
	 * @return instance of {@link CCFValue}
	 * @throws ResourceNotFoundException thrown when model creation fails
	 */
	public static CCFValue getCcfModel(String ccfContent) throws ResourceNotFoundException {
		log.debug("<getCcfModel>");
		if (FormTools.isValidateFormStringNull(ccfContent)) {
			log.debug("Empty CCF file");
			return null;
		}
		InputStream inStream = new ByteArrayInputStream(ccfContent.getBytes());
		return getCcfModel(inStream);
	}

	/**
	 * Creates a CCF model from the given ccf file.
	 * 
	 * @param ccfContent ccf file
	 * @return instance of {@link CCFValue}
	 * @throws ResourceNotFoundException thrown when model creation fails
	 */
	public static CCFValue getCcfModel(InputStream inStream) throws ResourceNotFoundException {
		log.debug("<getCcfModel>");

		Object res = JsonReaderHelper.load(inStream, CCFValue.class);
		if (res == null) {
			log.error("Empty CCF file");
			// TODO add i18n
			throw new ResourceNotFoundException("Error creating CCF model");
		}
		return ((CCFValue) res);
	}

}
