/**
 * VlbiExperiment.java
 * Created on Nov 22, 2007, 1:52:41 PM
 */
package pl.psnc.expres.model.experiment;

import java.util.ArrayList;
import java.util.List;

import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.remote.vex2ccf.model.CCFValue;

/**
 * {@link VlbiExperiment} class - used to describe VLBI experiment workflow. It
 * contains experiment details like name, description and list of resources and
 * their connections, vex file, ccf file
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class VlbiExperiment {

	/** Stores experiment description value object */
	private ExperimentInfo info;

	/** Stores workflow resources */
	private List<ResourceValue> resources;

	/** Holds content of Correlator Control File - CCF */
	private CCFValue ccf;

	/** Holds experiment description - VEX file */
	private byte vexFile[];

	/** Stores resource's connections */
	private byte connections[];

	/**
	 * Creates a new instance of the VlbiExperiment
	 */
	public VlbiExperiment() {
		this.resources = new ArrayList<ResourceValue>();
		this.info = new ExperimentInfo();
	}

	// ----------------------------------------------------------------
	// ----- Getters/Setters

	/**
	 * Get value of field: info
	 * 
	 * @return the info
	 */
	public ExperimentInfo getInfo() {
		return info;
	}

	/**
	 * Set value of field: info
	 * 
	 * @param info the info to set
	 */
	public void setInfo(ExperimentInfo info) {
		this.info = info;
	}

	/**
	 * Get value of field: resources
	 * 
	 * @return the resources
	 */
	public List<ResourceValue> getResources() {
		return resources;
	}

	/**
	 * Set value of field: resources
	 * 
	 * @param resources the resources to set
	 */
	public void setResources(List<ResourceValue> resources) {
		this.resources = resources;
	}

	/**
	 * Get value of field: vexFile
	 * 
	 * @return the vexFile
	 */
	public byte[] getVexFile() {
		return vexFile;
	}

	/**
	 * Set value of field: vexFile
	 * 
	 * @param vexFile the vexFile to set
	 */
	public void setVexFile(byte[] vexFile) {
		this.vexFile = vexFile;
	}

	/**
	 * Get value of field: connections
	 * 
	 * @return the connections
	 */
	public byte[] getConnections() {
		return connections;
	}

	/**
	 * Set value of field: connections
	 * 
	 * @param connections the connections to set
	 */
	public void setConnections(byte[] connections) {
		this.connections = connections;
	}

	/**
	 * Get value of field: ccf
	 * 
	 * @return the ccf
	 */
	public CCFValue getCcf() {
		return ccf;
	}

	/**
	 * Set value of field: ccf
	 * 
	 * @param ccf the ccf to set
	 */
	public void setCcf(CCFValue ccf) {
		this.ccf = ccf;
	}

}
