/**
 * ExperimentDetails.java
 * Created on Nov 12, 2007, 2:14:15 PM
 */
package pl.psnc.expres.model.experiment;

/**
 * VLBI Experiment Info (name, description, etc.) value objects
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class ExperimentInfo {

	/** Experiment identifier */
	private int id;

	/** Experiment name */
	private String name;

	/** Experiment description */
	private String description;
	
	/** Experiment: user, who has created experiment */
	private String userName;

	/** Experiment creation date */
	private String creationDate;

	// --------------------------------------------------------------------
	// ---- Setters/Getters

	/**
	 * Gets the value of the property creationDate
	 * 
	 * @return the creationDate
	 */
	public String getCreationDate() {
		return creationDate;
	}

	/**
	 * Sets value of the property: creationDate
	 * 
	 * @param creationDate the creationDate to set
	 */
	public void setCreationDate(String creationDate) {
		this.creationDate = creationDate;
	}

	/**
	 * Gets the value of the property id
	 * 
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * Sets value of the property: id
	 * 
	 * @param id the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the value of the property name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets value of the property: name
	 * 
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Gets the value of the property userName
	 * 
	 * @return the userName
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * Sets value of the property: userName
	 * 
	 * @param userName the userName to set
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * Gets the value of the property description
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets value of the property: description
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

}
