/*
 * ProgressIndicator.java
 *
 * Created on 16 marzec 2006, 13:23
 */

package pl.psnc.vlab.util.swing.thread;

import java.util.Locale;

import javax.swing.SwingUtilities;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.util.swing.gui.JBallsPane;
import pl.psnc.vlab.util.swing.gui.Message;

/**
 * Implementation of the interminate progress indicator.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * @deprecated classes from pl.psnc.vlab.util.thread should be used
 */
public class ProgressIndicator implements Progress {
	/** Logger instance */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Stores the progress dialog */
	private ProgressDialog progressDialog;

	private SwingWorker worker;

	/**
	 * Creates a new instance of ProgressIndicator, which automatically starts
	 * new thread which send new scenario to the VLab System
	 * 
	 * @param dialog
	 * @param locale
	 */
	public ProgressIndicator(ProgressDialog dialog, final Locale locale) {
		this.progressDialog = dialog;
		worker = new SwingWorker() {
			public Object construct() {
				return new ProgressWorker(locale == null ? Locale.getDefault() : locale);
			}
		};
		worker.start();
	}

	/**
	 * Creates a new instance of ProgressIndicator, which automatically starts
	 * new thread which send new scenario to the VLab System
	 * 
	 * @param locale locale
	 */
	@SuppressWarnings("deprecation")
	public ProgressIndicator(final Locale locale) {
		try {
			this.progressDialog = new JBallsPane(4, false, locale);
		} catch (VlabException e) {
			Message.showInfoMessage(null, "Failed to initialize Progress Dialog",
					Message.MESSAGE_TYPE_ERROR);
			// return;
		}
		worker = new SwingWorker() {
			public Object construct() {
				return new ProgressWorker(locale == null ? Locale.getDefault() : locale);
			}
		};
		worker.start();
	}

	/** Update GUI upon close dialog event */
	private final class GuiUpdater implements Runnable {

		public void run() {
			ProgressDialog progress = (ProgressDialog) progressDialog;
			progress.stop();
			progress.setVisible(false);
			progressDialog = null;
		}

	}

	/**
	 * Informs the progress thread that the long time task has finished. Closes
	 * the long time operation indicator.
	 */
	public void fireFinish() throws VlabException {
		try {
			SwingUtilities.invokeLater(new GuiUpdater());
		} catch (Exception err) {
			throw new VlabException("Error during long time operation cleanup.", err);
		}
	}

	/**
	 * The actual long running task. This runs in a SwingWorker thread.
	 */
	class ProgressWorker {
		ProgressWorker(Locale locale) {
			try {
				log.debug("<ProgressWorker>");
				progressDialog.start();
				progressDialog.setVisible(true);
				log.debug("</ProgressWorker>");
			} catch (Exception er) {
				er.printStackTrace();
				log.debug("</ProgressWorker:err>");
			}

		}

	}

}
