/*
 * LongTaskInterface.java
 *
 * Created on 18 marzec 2004, 12:23
 */

package pl.psnc.vlab.util.swing.thread;

/**
 * Interface used in time consuming operations launched in a seperate
 * thread
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * @deprecated classes from pl.psnc.vlab.util.thread should be used
 */
public interface LongTask {
    
    
    /**
     * Get the length of the task
     * @return the length of the task
     */
    public int getTaskLength();
    
    /**
     * Get the current state of the executed task
     * @return the current state of the executed task (where <CODE>getTaskLength() is max size </CODE>
     */    
    public int getProgress();
    
    
    /** Tells whether am execuded task has been completed
     * @return true/false
     */    
    public boolean isDone();
    
    
    /**
     * Return an object produced by the executed task. Usually it will
     * be the value returned by the method executed in the seperate thread.
     * @return If no value is produced the null value will be returned
     */    
    public Object getResult();
    
    /**
     * Indicates wheter the Long Task has thrown an exception
     * @return <CODE>true</CODE> if exception has been thrown, <CODE>false</CODE> otherwise
     */    
    public boolean exceptionThrown();
    
    /** Each exception which is cought during task execution will be returned 
     * by this method. 
     * @return exception object or null if no exception has been thrown
     */    
    public Exception getException();
}
