package pl.psnc.vlab.util.swing.gui;

import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.UIManager;

import pl.psnc.vlab.exception.VlabException;

/**
 * {@link SwingLocale} class - utility methods for setting the locale of the
 * swing components.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class SwingLocale {

	/**
	 * Initialize the JOption pane to the specified locale
	 * 
	 * @param locale locale which will be used to display button names
	 * @throws pl.psnc.vlab.exception.VlabException
	 */
	public static void initJFileChooser(Locale locale) throws VlabException {
		try {
			ResourceBundle rb = ResourceBundle.getBundle(
					"pl.psnc.vlab.util.swing.gui.JFileChooser", locale);

			UIManager.put("FileChooser.lookInLabelText", rb.getString("lookInLabelText"));
			UIManager.put("FileChooser.filesOfTypeLabelText", rb.getString("filesOfTypeLabelText"));
			UIManager.put("FileChooser.upFolderToolTipText", rb.getString("upFolderToolTipText"));
			UIManager.put("FileChooser.fileNameLabelText", rb.getString("fileNameLabelText"));
			UIManager.put("FileChooser.homeFolderToolTipText", rb
					.getString("homeFolderToolTipText"));
			UIManager.put("FileChooser.newFolderToolTipText", rb.getString("newFolderToolTipText"));
			UIManager.put("FileChooser.listViewButtonToolTipTextlist", rb
					.getString("listViewButtonToolTipTextlist"));
			UIManager.put("FileChooser.detailsViewButtonToolTipText", rb
					.getString("detailsViewButtonToolTipText"));
			UIManager.put("FileChooser.saveButtonText", rb.getString("saveButtonText"));
			UIManager.put("FileChooser.openButtonText", rb.getString("openButtonText"));
			UIManager.put("FileChooser.cancelButtonText", rb.getString("cancelButtonText"));
			UIManager.put("FileChooser.updateButtonText", rb.getString("updateButtonText"));
			UIManager.put("FileChooser.helpButtonText", rb.getString("helpButtonText"));
			UIManager.put("FileChooser.saveButtonToolTipText", rb
					.getString("saveButtonToolTipText"));
			UIManager.put("FileChooser.openButtonToolTipText", rb
					.getString("openButtonToolTipText"));
			UIManager.put("FileChooser.cancelButtonToolTipText", rb
					.getString("cancelButtonToolTipText"));
			UIManager.put("FileChooser.updateButtonToolTipText", rb
					.getString("updateButtonToolTipText"));
			UIManager.put("FileChooser.helpButtonToolTipText", rb
					.getString("helpButtonToolTipText"));
		} catch (Exception e) {
			throw new VlabException("Error during FileChooser initializiation. Details:"
					+ e.getMessage(), e);
		}
	}

	/**
	 * Initialize the JOption pane to the specified locale
	 * 
	 * @param locale locale which will be used to display button names
	 * @throws pl.psnc.vlab.exception.VlabException
	 */
	public static void initJOptionPane(Locale locale) throws VlabException {
		try {
			ResourceBundle rb = ResourceBundle.getBundle("pl.psnc.vlab.util.swing.gui.JOptionPane",
					locale);
			UIManager.put("OptionPane.cancelButtonText", rb.getString("cancelButtonText"));
			UIManager.put("OptionPane.noButtonText", rb.getString("noButtonText"));
			UIManager.put("OptionPane.okButtonText", rb.getString("okButtonText"));
			UIManager.put("OptionPane.yesButtonText", rb.getString("yesButtonText"));
		} catch (Exception e) {
			throw new VlabException("Error during JOptionPane initializiation. Details:"
					+ e.getMessage(), e);
		}
	}

}