/*
 * Message.java
 *
 * Created on 19 styczen 2002, 16:33
 */

package pl.psnc.vlab.util.swing.gui;

import java.awt.Component;

import javax.swing.JOptionPane;

import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link Message} class - set of message dialogs
 *
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * @deprecated {@link JMessage} should be used instead
 */
public abstract class Message {

	// Message dialogs types
	/** Error dialog */
	public static String MESSAGE_TYPE_ERROR = "err";
	/** Information dialog */
	public static String MESSAGE_TYPE_INF = "info";
	/** Warning dialog */
	public static String MESSAGE_TYPE_WARNING = "warn";
	/** Question dialog */
	public static String MESSAGE_TYPE_QUESTION = "question";

	// Option types
	/** Type used for showConfirmDialog. */
	public static final int DEFAULT_OPTION = JOptionPane.DEFAULT_OPTION;
	/** Type used for showConfirmDialog. */
	public static final int YES_NO_OPTION = JOptionPane.YES_NO_OPTION;

	/** Type used for showConfirmDialog. */
	public static final int YES_NO_CANCEL_OPTION = JOptionPane.YES_NO_CANCEL_OPTION;
	/** Type used for showConfirmDialog. */
	public static final int OK_CANCEL_OPTION = JOptionPane.OK_CANCEL_OPTION;

	// Returns value
	/** Return value form class method if OK is chosen */
	public static final int OK_OPTION = JOptionPane.OK_OPTION;
	/** Return value form class method if NO is chosen */
	public static final int NO_OPTION = JOptionPane.NO_OPTION;
	/** Return value form class method if YES is chosen */
	public static final int YES_OPTION = JOptionPane.YES_OPTION;
	/** Return value form class method if CANCEL is chosen */
	public static final int CANCEL_OPTION = JOptionPane.CANCEL_OPTION;

	/**
	 * Show Info message
	 * 
	 * @param object the parent compone
	 * @param message message
	 * @param type dialog type: MESSAGE_TYPE_ERROR, MESSAGE_TYPE_INF,
	 *            MESSAGE_TYPE_WARNING, MESSAGE_TYPE_QUESTION
	 */
	public static void showInfoMessage(Component object, Object message, String type) {

		if (type.equals(MESSAGE_TYPE_ERROR)) {
			JOptionPane.showMessageDialog(object, message, java.util.ResourceBundle.getBundle(
					"pl/psnc/vlab/util/swing/gui/Message").getString("form.title.error"),
					JOptionPane.ERROR_MESSAGE);
		} else if (type.equals(MESSAGE_TYPE_INF)) {
			JOptionPane.showMessageDialog(object, message, java.util.ResourceBundle.getBundle(
					"pl/psnc/vlab/util/swing/gui/Message").getString("form.title.info"),
					JOptionPane.INFORMATION_MESSAGE);
		} else if (type.equals(MESSAGE_TYPE_WARNING)) {
			JOptionPane.showMessageDialog(object, message, java.util.ResourceBundle.getBundle(
					"pl/psnc/vlab/util/swing/gui/Message").getString("form.title.warning"),
					JOptionPane.WARNING_MESSAGE);
		} else if (type.equals(MESSAGE_TYPE_QUESTION)) {
			JOptionPane.showMessageDialog(object, message, java.util.ResourceBundle.getBundle(
					"pl/psnc/vlab/util/swing/gui/Message").getString("form.title.question"),
					JOptionPane.QUESTION_MESSAGE);
		}
	}

	/**
	 * Show Info message
	 * 
	 * @param object the parent component
	 * @param message message
	 * @param title dialog title
	 * @param optionType the options to display in the pane: DEFAULT_OPTION,
	 *            YES_NO_OPTION, YES_NO_CANCEL_OPTION, OK_CANCEL_OPTION
	 * @param type the Icon image to display
	 * @return the option, which have been choosen
	 */
	public static int showConfirmDialog(Component object, Object message, String title,
			int optionType, String type) {
		int result = -1;
		if (type.equals(MESSAGE_TYPE_ERROR)) {
			result = JOptionPane.showConfirmDialog(object, message, title, optionType,
					JOptionPane.ERROR_MESSAGE);
		} else if (type.equals(MESSAGE_TYPE_INF)) {
			result = JOptionPane.showConfirmDialog(object, message, title, optionType,
					JOptionPane.INFORMATION_MESSAGE);
		} else if (type.equals(MESSAGE_TYPE_WARNING)) {
			result = JOptionPane.showConfirmDialog(object, message, title, optionType,
					JOptionPane.WARNING_MESSAGE);
		} else if (type.equals(MESSAGE_TYPE_QUESTION)) {
			result = JOptionPane.showConfirmDialog(object, message, title, optionType,
					JOptionPane.QUESTION_MESSAGE);
		}
		return result;
	}
}
