package pl.psnc.vlab.util.swing.gui;

import java.awt.*;
import java.awt.image.*;
import javax.swing.border.*;

public class FillBackgroundBorder implements Border {
    private final BufferedImage original;
    private BufferedImage rescaled;

    public FillBackgroundBorder(BufferedImage original) {
        this.original = original;
        this.rescaled = original;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (width != rescaled.getWidth() || height != rescaled.getHeight()) {
            System.out.println("rescaling");
            int transparency = original.getColorModel().getTransparency();
            rescaled.flush();
            rescaled = rescale(original, width, height, transparency);
        }
        g.drawImage(rescaled, 0, 0, null);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(0,0,0,0);
    }

    public boolean isBorderOpaque() {
        return true; //because insets are empty
    }

    static BufferedImage rescale(BufferedImage original, int width, int height, int transparency) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage rescaled = gc.createCompatibleImage(width, height, transparency);
        Graphics2D g = rescaled.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(original, 0, 0, width, height, null);
        g.dispose();
        return rescaled;
    }
}


