/*
 * ImageFactory.java
 *
 * Created on 14 maj 2004, 15:29
 */

package pl.psnc.vlab.util.image;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * {@link ImageFactory} class - image factory returns an image by the given key.
 * If the image is not found it will be created.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public abstract class ImageFactory {

	/** Instance of logger */
	private static Log log = LogFactory.getLog("pl.psnc.vlab.util.image.ImageFactory");

	/** Stores images map */
	private static Map<String, ImageBean> imageList = new HashMap<String, ImageBean>();

	/**
	 * Get the ImageBean by the given key.
	 * 
	 * @param imageName image name
	 * @return ImageBean, which stores an image icon
	 */
	public static ImageBean getImageBean(String imageName) {
		log.debug("<getImageBean icon=" + imageName + ">");
		if (imageName == null) {
			log.debug("Image name is NULL");
			return null;
		}
		ImageBean imageBean = imageList.get(imageName);
		if (imageBean == null) {
			imageBean = new ImageBean(imageName);
			imageList.put(imageName, imageBean);
		}

		log.debug("<getImageBean>");
		return imageBean;
	}

}
