/*
 * ImageBean.java
 *
 * Created on 14 maj 2004, 15:24
 */

package pl.psnc.vlab.util.image;

import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * {@link ImageBean} class - image bean class is used to store the system images
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class ImageBean {

	/** Instance of logger */
	private Log log = LogFactory.getLog(getClass().getName());

	private static final String NO_ICON = "images/blank16.gif";

	/** Holds value of property imageName. */
	private String imageName;

	/** Holds value of property image. */
	private ImageIcon image;

	/**
	 * Creates a new instance of ImageBean
	 * 
	 * @param imageName image name
	 */
	public ImageBean(String imageName) {
		this.imageName = imageName;
		try {
			if (imageName.startsWith("http")) {
				image = new ImageIcon(new URL(imageName));
			} else {
				image = new ImageIcon(this.getClass().getClassLoader().getResource(imageName));
			}
		} catch (Exception e) {
			log.error("Error while reading image file: " + imageName + ". Details:"
					+ e.getMessage());
			try {
				// add no image icon
				image = new ImageIcon(NO_ICON);
			} catch (Exception err) {
				log.error("Error while reading default no icon file");
			}
		}
	}

	/**
	 * Getter for property imageName.
	 * 
	 * @return Value of property imageName.
	 * 
	 */
	public String getImageName() {
		return this.imageName;
	}

	/**
	 * Setter for property imageName.
	 * 
	 * @param imageName New value of property imageName.
	 * 
	 */
	public void setImageName(String imageName) {
		this.imageName = imageName;
	}

	/**
	 * Getter for property image.
	 * 
	 * @return Value of property image.
	 * 
	 */
	public ImageIcon getImage() {
		return this.image;
	}

	/**
	 * Setter for property image.
	 * 
	 * @param image New value of property image.
	 * 
	 */
	public void setImage(ImageIcon image) {
		this.image = image;
	}

}
