/**
 * Created on Aug 5, 2008
 */
package pl.psnc.vlab.util.i18n;

/**
 * {@link BundleHelper} class - resource bundle helper class. The class is used
 * for internationalised names lookup.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class BundleHelper {

	/** Stores instance of field: resourceBundleManager */
	private ResourceBundleManager rBundleManager;

	/** Stores instance of field: bundle */
	private final String bundle;

	/**
	 * Creates a new instance {@link BundleHelper} with the given resource
	 * bundle name.
	 * 
	 * @param bundle resource bundle name
	 */
	public BundleHelper(String bundle) {
		this.bundle = bundle;
	}

	/**
	 * Get internationalised value for the given key.
	 * 
	 * @param key key value
	 * @return internationalised value for the given key
	 */
	public String getI18nValue(String key) {
		if (rBundleManager == null) {
			rBundleManager = new ResourceBundleManager(this.bundle);
		}
		return rBundleManager.getValue(key);
	}

}
