package pl.psnc.vlab.util.gui.progress;

/**
 * ProgressTask interface - defines a set of method to deal with a long task
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface ProgressTask {

	/**
	 * Show Progress bar
	 * 
	 * @param interminate defines the behavior of the progress: interminate or
	 *        not
	 */
	public void showProgress(boolean interminate);

	/**
	 * Show Progress bar with the initial message
	 * 
	 * @param message message to be displayed on the status bar
	 * @param interminate defines the behavior of the progress: interminate or
	 *        not
	 */
	public void showProgress(String message, boolean interminate);

	/**
	 * Hides Progress bar
	 */
	public void hideProgress();

	/**
	 * Update current progress bar message. Please note, that progress has to be
	 * turned on first
	 * 
	 * @param messages list of messages to be displayed. Each message will be
	 *        separated by white space
	 */
	public void updateMessage(String... messages);

}
