/*
 * Created by JFormDesigner on Tue Dec 18 14:50:37 CET 2007
 */

package pl.psnc.vlab.util.gui.progress;

import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;
import javax.swing.border.SoftBevelBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.image.ImageBean;
import pl.psnc.vlab.util.image.ImageFactory;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

/**
 * {@link JStatusBar} class - represents an application status bar pane.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JStatusBar extends JPanel implements ProgressTask {

	/** Default Serial UID */
	private static final long serialVersionUID = 1L;

	/** Specifies the location of country flags */
	private static final String FLAGS_PATH = "images/flags/";

	/** Specifies the extension of the country flag file */
	private static final String FLAG_FILE_TYPE = ".gif";

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Stores an instance of locale */
	private Locale locale;

	/**
	 * Creates a new instance of {@link JStatusBar} with locale set to default
	 */
	public JStatusBar() {
		this(null);
	}

	/**
	 * Creates a new instance of {@link JStatusBar}
	 * 
	 * @param locale specifies the current locale to be used
	 */
	public JStatusBar(Locale locale) {
		this.locale = locale != null ? locale : Locale.getDefault();
		initComponents();
		initLocaleIcon();
	}

	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.common_gui");
		jMessagePane = new JPanel();
		jProgressContent = new JPanel();
		jMessageLbl = new JLabel();
		jProgressBar = new JProgressBar();
		JLocalePane = new JPanel();
		jLocaleLbl = new JLabel();
		JUserPane = new JPanel();
		jUserNameLbl = new JLabel();
		jDatePane = new JPanel();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setName("this");
		setLayout(new FormLayout(new ColumnSpec[] {
				new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
				FormFactory.DEFAULT_COLSPEC, FormFactory.BUTTON_COLSPEC,
				new ColumnSpec("max(pref;50dlu):grow") }, RowSpec.decodeSpecs("fill:default")));

		// ======== jMessagePane ========
		{
			jMessagePane.setBorder(new SoftBevelBorder(SoftBevelBorder.LOWERED));
			jMessagePane.setName("jMessagePane");
			jMessagePane.setLayout(new FormLayout("default:grow", "fill:default"));

			// ======== jProgressContent ========
			{
				jProgressContent.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
				jProgressContent.setVisible(false);
				jProgressContent.setName("jProgressContent");
				jProgressContent.setLayout(new FormLayout(new ColumnSpec[] {
						new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("min(default;200dlu)"),
						FormFactory.UNRELATED_GAP_COLSPEC }, RowSpec.decodeSpecs("default")));

				// ---- jMessageLbl ----
				jMessageLbl.setName("jMessageLbl");
				jProgressContent.add(jMessageLbl, cc.xy(1, 1));

				// ---- jProgressBar ----
				jProgressBar.setIndeterminate(true);
				jProgressBar.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
				jProgressBar
						.setToolTipText(bundle.getString("status.bar.jProgressBar.toolTipText"));
				jProgressBar.setString("Please wait ...");
				jProgressBar.setName("jProgressBar");
				jProgressContent.add(jProgressBar, cc.xy(3, 1));
			}
			jMessagePane.add(jProgressContent, cc.xy(1, 1));
		}
		add(jMessagePane, cc.xy(1, 1));

		// ======== JLocalePane ========
		{
			JLocalePane.setBorder(new SoftBevelBorder(SoftBevelBorder.LOWERED));
			JLocalePane.setName("JLocalePane");
			JLocalePane.setLayout(new FormLayout(new ColumnSpec[] {
					FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
					FormFactory.RELATED_GAP_COLSPEC }, RowSpec.decodeSpecs("fill:default")));

			// ---- jLocaleLbl ----
			jLocaleLbl.setHorizontalAlignment(SwingConstants.CENTER);
			jLocaleLbl.setName("jLocaleLbl");
			JLocalePane.add(jLocaleLbl, cc.xywh(2, 1, 1, 1, CellConstraints.LEFT,
					CellConstraints.CENTER));
		}
		add(JLocalePane, cc.xy(2, 1));

		// ======== JUserPane ========
		{
			JUserPane.setBorder(new SoftBevelBorder(SoftBevelBorder.LOWERED));
			JUserPane.setName("JUserPane");
			JUserPane.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC,
					FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC }, RowSpec
					.decodeSpecs("fill:default")));

			// ---- jUserNameLbl ----
			jUserNameLbl.setHorizontalAlignment(SwingConstants.CENTER);
			jUserNameLbl.setName("jUserNameLbl");
			JUserPane.add(jUserNameLbl, cc.xywh(2, 1, 1, 1, CellConstraints.LEFT,
					CellConstraints.CENTER));
		}
		add(JUserPane, cc.xywh(3, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));

		// ======== jDatePane ========
		{
			jDatePane.setBorder(new SoftBevelBorder(SoftBevelBorder.LOWERED));
			jDatePane.setName("jDatePane");
			jDatePane.setLayout(new FormLayout("default", "default"));
		}
		add(jDatePane, cc.xy(4, 1));
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JPanel jMessagePane;
	private JPanel jProgressContent;
	private JLabel jMessageLbl;
	private JProgressBar jProgressBar;
	private JPanel JLocalePane;
	private JLabel jLocaleLbl;
	private JPanel JUserPane;
	private JLabel jUserNameLbl;
	private JPanel jDatePane;

	// JFormDesigner - End of variables declaration //GEN-END:variables

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.progress.ProgressTask#hideProgress()
	 */
	public void hideProgress() {
		jProgressContent.setVisible(false);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.progress.ProgressTask#showProgress(boolean)
	 */
	public void showProgress(boolean interminate) {
		jProgressBar.setIndeterminate(interminate);
		jProgressContent.setVisible(true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.progress.ProgressTask#showProgress(java.lang.String,
	 *      boolean)
	 */
	public void showProgress(String message, boolean interminate) {
		jProgressBar.setIndeterminate(interminate);
		jMessageLbl.setText(message);
		jProgressContent.setVisible(true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.progress.ProgressTask#updateMessage(java.lang.String[])
	 */
	public void updateMessage(String... messages) {
		StringBuffer tmpBuf = new StringBuffer();
		for (String msg : messages) {
			tmpBuf.append(msg).append(" ");
		}
		jMessageLbl.setText(tmpBuf.toString().trim());
	}

	/**
	 * Sets user first and last name on the status bar
	 * 
	 * @param firstName first name
	 * @param lastName last name
	 */
	public void setUser(String firstName, String lastName) {
		setUser(String.format("%s %s", firstName, lastName));
	}

	/**
	 * Sets user name on the status bar
	 * 
	 * @param userName user name
	 */
	public void setUser(String userName) {
		jUserNameLbl.setText(userName != null ? userName : "");
	}

	// -------------------------------------------------------------------------
	// ---- Private helper methods

	/**
	 * Paints current locale icon
	 */
	private void initLocaleIcon() {

		jLocaleLbl.setToolTipText(locale.getDisplayCountry());
		// set icon
		try {

			String flag = new StringBuffer(FLAGS_PATH).append(
					locale.getISO3Language().toLowerCase()).append(FLAG_FILE_TYPE).toString();
			ImageBean flagImg = ImageFactory.getImageBean(flag);
			if (flagImg != null) {
				jLocaleLbl.setIcon(flagImg.getImage());
			}
		} catch (Exception e) {
			log.error("Locale flag was not found. Details" + e.getMessage());
		}
	}

}
