/*
 * AbstractDefaultTableModel.java
 *
 */
package pl.psnc.vlab.util.gui.model.table;

import javax.swing.table.AbstractTableModel;

/**
 * {@link AbstractDefaultTableModel} class - abstract table model class. his
 * abstract class provides default implementations for most of the methods in
 * the TableModel interface.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class AbstractDefaultTableModel extends AbstractTableModel {

	/** Stores a list of column names */
	private String[] columnNames;

	/** Stores a list of column types */
	private Class<?>[] columnTypes;

	/** Specifies editable columns */
	private boolean[] editable;

	/**
	 * Creates a new instance of AbstractDefaultTableModel
	 * 
	 */
	public AbstractDefaultTableModel() {

	}

	/**
	 * Creates a new instance of AbstractDefaultTableModel with column names
	 * specified.
	 * 
	 * 
	 * @param columnNames column names
	 * @param editable specifies whether column is editable
	 */
	public AbstractDefaultTableModel(String columnNames[], boolean editable[]) {
		this.columnNames = columnNames;
		this.editable = editable;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return columnNames != null ? columnNames.length : 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
	 */
	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return columnTypes != null && columnIndex < columnTypes.length ? columnTypes[columnIndex]
				: super.getColumnClass(columnIndex);
	}

	/*
	 * s process (non-Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#getColumnName(int)
	 */
	public String getColumnName(int col) {
		return columnNames != null && col < columnNames.length ? columnNames[col] : "";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#isCellEditable(int, int)
	 */
	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return editable != null && columnIndex < editable.length ? editable[columnIndex] : false;
	}

	// --------------------------------------------------------------------------
	// ----- Helper methods

	/**
	 * Set column names
	 * 
	 * @param columnNames the columnNames to set
	 */
	public void setColumnNames(String[] columnNames) {
		this.columnNames = columnNames;
	}

	/**
	 * Set column types
	 * 
	 * @param columnTypes the columnTypes to set
	 */
	public void setColumnTypes(Class<?>[] columnTypes) {
		this.columnTypes = columnTypes;
	}

	/**
	 * Set editable property for each column. Editable property specifies
	 * whether given column is editable
	 * 
	 * @param editable the editable to set
	 */
	public void setEditable(boolean[] editable) {
		this.editable = editable;
	}

}