/*
 * AbstractCustomTableModel.java
 *
 */
package pl.psnc.vlab.util.gui.model.table;

import pl.psnc.vlab.util.gui.model.info.ModelProperties;

/**
 * AbstractCustomTableModel - abstract table model class. This abstract class
 * provides default implementations for most of the methods in the TableModel
 * interface. It can be customized by ModelProperties object
 *
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 *
 */
public abstract class AbstractCustomTableModel extends AbstractDefaultTableModel {

	/** Default Serial Uid */
	private static final long serialVersionUID = 1L;

	/** Stores an instance of Model Properties */
	private ModelProperties modelProperties;

	/**
	 * Creates a new instance of AbstractCustomTableModel
	 * 
	 * @param modelProperties instance of ModelProperties
	 */
	public AbstractCustomTableModel(ModelProperties modelProperties) {
		super(modelProperties.getColumnNames(), modelProperties.getEditable());
		setColumnTypes(modelProperties.getColumnTypes());
		this.modelProperties = modelProperties;
	}

	// -------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of modelProperties
	 * 
	 * @return the modelProperties
	 */
	public ModelProperties getModelProperties() {
		return modelProperties;
	}

}