/*
 * AbstractCustomObservableTableModel.java
 *
 */
package pl.psnc.vlab.util.gui.model.table;

import pl.psnc.vlab.util.gui.model.info.ModelProperties;

/**
 * {@link AbstractCustomObservableTableModel} class - abstract table model
 * class. This abstract class provides default implementations for most of the
 * methods in the TableModel interface. The class provides also notification
 * mechanism for changes in the model data. It can be customised by
 * ModelProperties object.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class AbstractCustomObservableTableModel extends
		AbstractDefaultObservableTableModel {

	/** Default Serial Uid */
	private static final long serialVersionUID = 1L;

	/** Stores an instance of Model Properties */
	private ModelProperties modelProperties;

	/**
	 * Creates a new instance of AbstractCustomObservableTableModel
	 * 
	 * @param modelProperties instance of ModelProperties
	 */
	public AbstractCustomObservableTableModel(ModelProperties modelProperties) {
		super(modelProperties.getColumnNames(), modelProperties.getEditable());
		setColumnTypes(modelProperties.getColumnTypes());
		this.modelProperties = modelProperties;
	}

	// -------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of modelProperties
	 * 
	 * @return the modelProperties
	 */
	public ModelProperties getModelProperties() {
		return modelProperties;
	}

}