package pl.psnc.vlab.util.gui.model.info;

/**
 * {@link TableModelInfo} interface is used by AbstractTableModel classes to
 * provide general information about model JTable component.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 * @param <T> definition of row value data type
 * @param <V> definition of the model data result set
 * 
 */
public interface TableModelInfo<T, V> {

	/**
	 * Get model data for the given Table Model
	 * 
	 * @return model data for the given Table Model
	 */
	public V getModelData();

	/**
	 * Get value of the given model at specified row
	 * 
	 * @param row row index
	 * @return value of the given model at specified row
	 */
	public T getRowValue(int row);

	/**
	 * Get number of rows in the current table model
	 * 
	 * @return number of rows in the current table model
	 */
	public int getRowCount();

}
