/**
 * 
 */
package pl.psnc.vlab.util.gui.model.info;

import javax.swing.JTable;

/**
 * {@link ColumnDecorator} class. Defines a set of properties to decorate
 * columns in {@link JTable} i.e. column size, column alignment
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ColumnDecorator {

	/** Stores minimum size */
	private Integer min;

	/** Stores maximum size */
	private Integer max;

	/** Stores preferred size */
	private Integer prefered;

	/** Stores horizontal alignment */
	private Integer horizontalAlignment;

	/**
	 * Creates new {@link ColumnDecorator}
	 * 
	 * @param prefered column preferred size
	 * @param max column maximum size
	 */
	public ColumnDecorator(Integer prefered, Integer max) {
		this.prefered = prefered;
		this.max = max;
	}

	/**
	 * Creates new {@link ColumnDecorator}
	 * 
	 * @param prefered column preferred size
	 * @param min column minimum size
	 * @param max column maximum size
	 */
	public ColumnDecorator(Integer prefered, Integer min, Integer max) {
		this.prefered = prefered;
		this.min = min;
		this.max = max;
	}

	/**
	 * Creates new {@link ColumnDecorator}
	 * 
	 * @param prefered column preferred size
	 */
	public ColumnDecorator(Integer prefered) {
		this.prefered = prefered;
	}

	/**
	 * Get value of min
	 * 
	 * @return the min
	 */
	public Integer getMin() {
		return min;
	}

	/**
	 * Set value of field min
	 * 
	 * @param min the min to set
	 */
	public void setMin(Integer min) {
		this.min = min;
	}

	/**
	 * Get value of max
	 * 
	 * @return the max
	 */
	public Integer getMax() {
		return max;
	}

	/**
	 * Set value of field max
	 * 
	 * @param max the max to set
	 */
	public void setMax(Integer max) {
		this.max = max;
	}

	/**
	 * Get value of prefered
	 * 
	 * @return the prefered
	 */
	public Integer getPrefered() {
		return prefered;
	}

	/**
	 * Set value of field prefered
	 * 
	 * @param prefered the prefered to set
	 */
	public void setPrefered(Integer prefered) {
		this.prefered = prefered;
	}

	/**
	 * Get value of horizontalAlignment
	 * 
	 * @return the horizontalAlignment
	 */
	public Integer getHorizontalAlignment() {
		return horizontalAlignment;
	}

	/**
	 * Set value of field horizontalAlignment
	 * 
	 * @param horizontalAlignment the horizontalAlignment to set
	 */
	public void setHorizontalAlignment(Integer horizontalAlignment) {
		this.horizontalAlignment = horizontalAlignment;
	}

}
