/**
 * 
 */
package pl.psnc.vlab.util.gui.frame;

import java.awt.Color;

import pl.psnc.vlab.util.i18n.I18NInfo;

/**
 * {@link JGenericPane} class - parent, top level pane for all GUI forms.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JGenericPane extends GenericGradientPane implements I18NInfo {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores a name of the internal frame */
	private String frameTitle;

	/**
	 * Stores instance of concrete pane prefix. Prefix is used i.e. in
	 * internationalisation
	 */
	private final String prefix;

	/**
	 * Create new instance of JGenericPanel with frame title, frame prefix and
	 * gradient colors defined
	 * 
	 * @param frameTitle title of the current frame
	 * @param prefix frame prefix. Prefix is used by i18n
	 * @param gradient gradient colors which will be used for the current frame
	 */
	public JGenericPane(String frameTitle, String prefix, Color gradient[]) {
		super(gradient);
		this.frameTitle = frameTitle;
		this.prefix = prefix;
	}

	/**
	 * Create new instance of JGenericPanel. The frame title and prefix are
	 * empty. Default gradient colors are used -> they are defined in the super
	 * class.
	 */
	public JGenericPane() {
		this("", "", null);
	}

	/**
	 * Create new instance of JGenericPanel with frame title and frame prefix
	 * defined. Default gradient colors are used -> they are defined in the
	 * super class.
	 * 
	 * @param frameTitle title of the current frame
	 * @param prefix frame prefix. Prefix is used by i18n
	 */
	public JGenericPane(String frameTitle, String prefix) {
		this(frameTitle, prefix, null);
	}

	/**
	 * Creates new gradient pane with the gradient colors defined. The frame
	 * title and prefix are set to empty strings.
	 * 
	 * @param gradient pane gradient
	 */
	public JGenericPane(Color gradient[]) {
		this("", "", gradient);
	}

	// ---------------------------------------------------------------------
	// -- Setters / Getters

	public String getFrameTitle() {
		return frameTitle;
	}

	public void setFrameTitle(String frameTitle) {
		this.frameTitle = frameTitle;
	}

	/**
	 * @return the prefix
	 */
	public String getPrefix() {
		return prefix;
	}

}
