/*
 * GenericGradientPane.java
 *
 * Created on 25 kwiecien 2005, 13:33
 */

package pl.psnc.vlab.util.gui.frame;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;

import pl.psnc.vlab.util.swing.gui.ColorKeys;

/**
 * The class is a generic pane which is embedded in the internal frame
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 */
public class GenericGradientPane extends javax.swing.JPanel {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores the first gradient color */
	private Color firstColor;

	/** Stores the second gradient color */
	private Color secondColor;

	/**
	 * Creates new gradient pane with the gradient colors defined
	 * 
	 * @param firstColor
	 * @param secondColor
	 */
	public GenericGradientPane(Color firstColor, Color secondColor) {
		this.firstColor = firstColor;
		this.secondColor = secondColor;
	}

	/**
	 * Creates new gradient pane with the gradient colors defined
	 * 
	 * @param gradient gradient color
	 */
	public GenericGradientPane(Color gradient[]) {
		if (gradient != null && gradient.length == 2) {
			this.firstColor = gradient[0];
			this.secondColor = gradient[1];
		} else {
			this.firstColor = ColorKeys.GRADIENT_PANE_HEADER[0];
			this.secondColor = ColorKeys.GRADIENT_PANE_HEADER[1];
		}
	}

	/**
	 * Creates new gradient pane with the default gradient colors defined. See {@link ColorKeys}
	 * GRADIENT_PANE_HEADER.
	 */
	public GenericGradientPane() {
		this(null);
	}

	/**
	 * Override paintComponent method to fill panel with the gradient
	 * 
	 * @param g
	 */
	protected void paintComponent(java.awt.Graphics g) {
		super.paintComponent(g);
		if (!isOpaque()) {
			return;
		}
		int width = getWidth();
		int height = getHeight();

		Graphics2D g2 = (Graphics2D) g;
		Paint storedPaint = g2.getPaint();
		g2.setPaint(new GradientPaint(0, 0, firstColor, width, 0, secondColor));
		g2.fillRect(0, 0, width, height);
		g2.setPaint(storedPaint);
	}

}
