package pl.psnc.vlab.util.gui.action;

import javax.swing.ImageIcon;

import pl.psnc.vlab.util.i18n.ResourceBundleManager;
import pl.psnc.vlab.util.image.ImageFactory;

/**
 * {@link LocalizedAbstractAction} class - provides default implementation for
 * the JFC Action interface with the localised text descriptions.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class LocalizedAbstractAction extends AbstractActionDefault {

	/** Stores instance of field: resourceBundleManager */
	private ResourceBundleManager rBundleManager;

	/**
	 * Define an Action Object with a specified action name, icon and short
	 * description.
	 * 
	 * @param nameKey name of the action
	 * @param iconPath the icon for the current action
	 * @param description action short description
	 * 
	 */
	public LocalizedAbstractAction(String nameKey, String iconPath, String description) {
		super(ImageFactory.getImageBean(iconPath) != null ? ImageFactory.getImageBean(iconPath)
				.getImage() : null);
		setName(getI18nValue(nameKey));
	}

	/**
	 * Get bundle with the i18n keys for the given exception
	 * 
	 * @return bundle name for the given exception
	 */
	public abstract String getBundle();

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.AbstractActionDefault#setShortDescription(java.lang.String)
	 */
	public void setShortDescription(String description) {
		String msg = getI18nValue(description);
		super.setShortDescription(msg != null ? msg : description);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.AbstractActionDefault#setAcceleratorKey(java.lang.String)
	 */
	@Override
	public void setAcceleratorKey(String acceleratorKey) {
		String val = getI18nValue(acceleratorKey);
		super.setAcceleratorKey(val);
	}

	/**
	 * Set mnemonic key for the given action
	 * 
	 * @param mnemonicKey
	 */
	public void setMnemonic(String mnemonicKey) {
		String val = getI18nValue(mnemonicKey);
		super.setMnemonic(val.charAt(0));
	}

	/**
	 * Set disabled icon
	 * 
	 * @param iconPath path to the disabled icon
	 */
	public void setDisabledActionIcon(String iconPath) {
		ImageIcon icon = ImageFactory.getImageBean(iconPath).getImage();
		super.setDisabledActionIcon(icon);
	}

	// ----------------------------------------------------------------------------------
	// ---- Private Helper Methods

	/**
	 * Get internationalised value for the given key.
	 * 
	 * @param key key value
	 * @return internationalised value for the given key
	 */
	private String getI18nValue(String key) {
		if (rBundleManager == null) {
			rBundleManager = new ResourceBundleManager(getBundle());
		}
		return rBundleManager.getValue(key);
	}
}
