/*
 * VlabRemote.java
 *
 * Created on 4 marzec 2004, 15:10
 */

package pl.psnc.vlab.remote.session;

import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.values.management.SessionValue;

/**
 * This it the interface to the VLab Comunnication Proxy module (which is
 * written in C). It allows sending messages to the VLab sytem.
 * @author  <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public interface VlabSessionRemote {
    
    
    /**
     * Retrieve session information by the given session key
     * @return session value object
     * @param sessionKey session key
     * @throws VlabException indicates an exception which may occur during call
     */
    public SessionValue getAppSession(String sessionKey) throws VlabException;
    
    
    /**
     * Checks whether the current session is valid.
     * The session is valid if the following condition is true:
     *  current_timestamp < last_valid_timestamp + timestamp_limit
     *  timestamo_limit is stored in the database
     * @return <CODE>true</CODE> if the session is valid <CODE>false</CODE> otherwise
     * @param sessionKey session key
     * @throws VlabException indicates an exception which may occur during call
     */
    public boolean isSessionValid(String sessionKey) throws VlabException;
    
    
    
    /**
     * Deletes session from the database by the given session key
     * @param sessionKey session key
     * @throws VlabException indicates an exception which may occur during call
     * @return <CODE>true</CODE> if the operation succeeds <CODE>false</CODE> otherwise
     */
    public boolean removeSession(String sessionKey) throws VlabException;
    
    
    
    /**
     * Updates timestamp in the current session
     * @param sessionKey session key
     * @throws VlabException indicates an exception which may occur during call
     * @return <CODE>true</CODE> if the operation succeeds <CODE>false</CODE> otherwise
     */
    public boolean updateSession(String sessionKey) throws VlabException;
    
    
    
    /**
     * Get the  user proxy
     * @return user proxy as a byte array
     * @param userId 
     * @throws VlabException indicates an exception which may occur during call
     */
    public byte[] getUserProxy(int userId) throws VlabException;
    
       
}
