/*
 * SessionManager.java
 *
 * Created on 24 marzec 2004, 12:45
 */

package pl.psnc.vlab.management.session;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.util.swing.thread.LongTask;
import pl.psnc.vlab.util.swing.thread.SwingWorker;
import pl.psnc.vlab.values.management.SessionValue;

/**
 * Session manager is responsible for managing user rights, checking timeouts.
 * If the session expires the manager will perform the clean up and close the
 * application
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
@SuppressWarnings("deprecation")
public class SessionManager implements LongTask {

	/** Logger instance */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Exception instance */
	private VlabException exception = null;

	private static int counter = 0;

	/**
	 * Creates a new instance of SessionManager
	 * 
	 * @param sessionError the SessionError object contains the behavior when an
	 *            exception occurs
	 */
	public SessionManager(final SessionError sessionError) {

		final SwingWorker worker = new SwingWorker() {
			public Object construct() {
				return new ThreadWork();
			}

			public void finished() {
				if (!exceptionThrown()) {
					return;
				}
				sessionError.sessionError(getException());
			}
		};
		worker.start();
	}

	/**
	 * Gets the length of the task
	 * 
	 * @return the length of the current task
	 */
	public int getTaskLength() {
		return 0;
	}

	/**
	 * Gets the current state of the executed task
	 * 
	 * @return the current state of the executed task (where
	 *         <CODE>getTaskLength() is max size </CODE>
	 */
	public int getProgress() {
		return 0;
	}

	/**
	 * Tells whether am executed task has been completed
	 * 
	 * @return true/false
	 */
	public boolean isDone() {
		return false;
	}

	/**
	 * Returns an object produced by the executed task. Usually it will be the
	 * value returned by the method executed in separate thread. If no value is
	 * produced the null value will be returned
	 * 
	 * @return the result object produced by the current thread.If no value is
	 *         produced the <CODE>null</CODE> value will be returned
	 */
	public Object getResult() {
		return null;
	}

	/**
	 * Each exception which is cought during task execution will be returned by
	 * this method.
	 * 
	 * @return exception object or null if no exception has been thrown
	 */
	public Exception getException() {
		return exception;
	}

	/**
	 * Indicates whether the Long Task has thrown an exception
	 * 
	 * @return <CODE>true</CODE> if exception has been thrown,
	 *         <CODE>false</CODE> otherwise
	 */
	public boolean exceptionThrown() {
		if (exception == null) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * The actual long running task. This is run in the SwingWorker thread.
	 */
	class ThreadWork {
		/**
		 * new instance of the thread work.
		 */
		ThreadWork() {
			try {
				log.debug("<ThreadWork: " + counter++ + ">");
				// get session
				SessionValue sessionValue = SessionFactory.getSessionInstance();
				if (sessionValue == null) {
					log.debug("Session expired");
					exception = new VlabException("Session expired");
					return;
				}

				// check the time stamp
				if (!SessionFactory.isSessionValid()) {
					log.debug("Session expired");
					exception = new VlabException("Session expired");
					return;
				}
				log.debug("</ThreadWork>");
			} catch (java.lang.Exception er) {
				er.printStackTrace();
				exception = new VlabException(er.getMessage(), er);
			}

		}
	}
}
