/*
 * SessionFactory.java
 *
 * Created on 24 marzec 2004, 13:36
 */

package pl.psnc.vlab.management.session;

import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.management.PropertiesFactory;
import pl.psnc.vlab.remote.session.VlabSessionRemote;
import pl.psnc.vlab.remote.session.VlabSessionRemoteImpl;
import pl.psnc.vlab.values.management.SessionValue;

/**
 * Factory which is used to retrieve current session information
 * @author  <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 */
public class SessionFactory {
    
    /** Stores an instance of the session value */
    private static SessionValue sessionValue = null;
    
    
    /**
     * Get the session value object. If the session value object is null it will
     * be retrieved from the VLab system.
     * @throws VlabException if the session is not valid exception will be thrown
     * @return session value object
     */    
    public static SessionValue getSessionValue() throws VlabException{
        if(sessionValue == null){
            sessionValue = getSessionInstance();
        }
        return sessionValue;
    }
    
    /**
     * Gets the session information object from the VLab system.
     * @return session value object
     * @throws VlabException if the session is not valid exception will be thrown
     */
    public static SessionValue getSessionInstance() throws VlabException {
        VlabSessionRemote remote = new VlabSessionRemoteImpl();
        return remote.getAppSession( PropertiesFactory.getSessionKey() );
    }
    
    
    /**
     * Check whether the current session is valid.
     * The session is valid if the following condition is true:
     * current_timestamp < last_valid_timestamp + timestamp_limit
     * timestamp_limit is stored in the VLab database and managed by the VLab
     * portal.
     * @return <CODE>true</CODE> if the session is valid <CODE>false</CODE> otherwise
     * @throws VlabException if the session is not valid exception will be thrown
     */
    public static boolean isSessionValid() throws VlabException{
        VlabSessionRemote remote = new VlabSessionRemoteImpl();
        return remote.isSessionValid(PropertiesFactory.getSessionKey() );
    }         
    
    
    /**
     * Delete session from the database by the given session key
     * @throws VlabException if the session is not valid exception will be thrown
     * @return <CODE>true</CODE> if the operation succeeds <CODE>false</CODE> otherwise
     */
    public static boolean removeSession() throws VlabException {
        VlabSessionRemote remote = new VlabSessionRemoteImpl();
        return remote.removeSession(PropertiesFactory.getSessionKey() );
    }
    
    
    /**
     * Update timestamp in the current session
     * @throws VlabException if the session is not valid exception will be thrown
     * @return <CODE>true</CODE> if the operation succeeds <CODE>false</CODE> otherwise
     */
    public static boolean updateSession() throws VlabException {
        VlabSessionRemote remote = new VlabSessionRemoteImpl();
        return remote.updateSession(PropertiesFactory.getSessionKey() );
    }
    
    
}
