/*
 * SplashDialogWorker.java
 *
 * Created on 9 sierpien 2004, 15:13
 */

package pl.psnc.vlab.management;

import javax.swing.JDialog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.util.swing.thread.LongTask;
import pl.psnc.vlab.util.swing.thread.SwingWorker;

/**
 * {@link SplashDialogWorker} class - thread opens an splash window
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
@SuppressWarnings("deprecation")
public class SplashDialogWorker implements LongTask {

	/** Logger instance */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Represents an exception */
	private VlabException vlabExc = null;

	/** Long task status */
	private boolean done = false;

	/** Instance of the Splash Dialog */
	private JDialog splashDialog = null;

	/**
	 * Creates a new instance of AppInitializer
	 * 
	 * @param splashDialog the splash dialog, which will be displayed on
	 *            application startup
	 */
	public SplashDialogWorker(JDialog splashDialog) {
		this.splashDialog = splashDialog;

		final SwingWorker worker = new SwingWorker() {
			public Object construct() {
				return new SplashOpener();
			}

		};
		worker.start();
	}

	/**
	 * Indicates whether the Long Task has thrown an exception
	 * 
	 * @return <CODE>true</CODE> if exception has been thrown,
	 *         <CODE>false</CODE> otherwise
	 */
	public boolean exceptionThrown() {
		return vlabExc != null;
	}

	/**
	 * Get the current state of the executed task
	 * 
	 * @return the current state of the executed task (where
	 *         <CODE>getTaskLength() is max size </CODE>
	 */
	public int getProgress() {
		return 0;
	}

	/**
	 * Each exception which is cought during task execution will be returned by
	 * this method.
	 * 
	 * @return exception object or null if no exception has been thrown
	 */
	public Exception getException() {
		return vlabExc;
	}

	/**
	 * Return an object produced by the executed task. Usually it will be the
	 * value returned by the method executed in the separate thread.
	 * 
	 * @return If no value is produced the null value will be returned
	 */
	public Object getResult() {
		return null;
	}

	/**
	 * Get the length of the task
	 * 
	 * @return the length of the task
	 */
	public int getTaskLength() {
		return 0;
	}

	/**
	 * Tells whether am executed task has been completed
	 * 
	 * @return true/false
	 */
	public boolean isDone() {
		return done;
	}

	/**
	 * The actual long running task. This runs in a SwingWorker thread.
	 */
	class SplashOpener {
		/**
		 * The thread which opens the splash dialog
		 */
		SplashOpener() {
			try {
				log.debug("<SplashOpener>");
				splashDialog.setVisible(true);
				done = true;
				log.debug("</SplashOpener>");
			} catch (java.lang.Exception er) {
				er.printStackTrace();
				done = true;
				log.debug("</InSplashOpener-Err>");
				vlabExc = new VlabException(er.getLocalizedMessage());
			}

		}
	}// end of Init class
}
