/*
 * VlabException.java
 *
 * Created on 13 luty 2004, 16:23
 */

package pl.psnc.vlab.exception;

/**
 * {@link VlabException} class - represents the exceptions which are thrown in
 * the system.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class VlabException extends AbstractException {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores a default name of resource bundle container */
	private final static String BUNDLE = "bundle/common_errors";

	/** Stores error code */
	private final static int ERROR_CODE = 200;

	/**
	 * Creates a new instance of VlabException
	 * 
	 * @param message error description
	 */
	public VlabException(String message) {
		super(ERROR_CODE, message);
	}

	/**
	 * Creates a new instance of VlabException
	 * 
	 * @param e source exception
	 * @param message error description
	 */
	public VlabException(String message, Exception e) {
		super(ERROR_CODE, message, e);
	}

	/**
	 * Creates a new instance of VlabException
	 * 
	 * @param code code number
	 * @param message error description
	 */
	public VlabException(String message, int code) {
		super(code, message);
	}

	/**
	 * Creates a new instance of VlabException
	 * 
	 * @param code code number
	 * @param message error description
	 */
	public VlabException(String message, int code, Exception e) {
		super(code, message, e);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.exception.AbstractException#getBundle()
	 */
	@Override
	public String getBundle() {
		return BUNDLE;
	}

}
