package pl.psnc.vlab.exception;

/**
 * {@link ResourceNotFoundException} class - exception thrown during data model
 * initialization, if given resource cannot be found
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * @version 1.0
 */
public class ResourceNotFoundException extends AbstractException {

	/** serialVersionUID default UID */
	private static final long serialVersionUID = 1L;

	/** Stores a default name of resource bundle container */
	private final static String BUNDLE = "bundle/common_errors";

	/** Stores error code */
	private final static int ERROR_CODE = 100;

	/**
	 * Creates a new instance of VlabException
	 * 
	 * @param message error description
	 */
	public ResourceNotFoundException(String message) {
		super(ERROR_CODE, message);
	}

	/**
	 * Creates a new instance of VlabException
	 * 
	 * @param e source exception
	 * @param message error description
	 */
	public ResourceNotFoundException(String message, Exception e) {
		super(ERROR_CODE, message, e);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.exception.AbstractException#getBundle()
	 */
	@Override
	public String getBundle() {
		return BUNDLE;
	}
}
