/*
 * SslFactory.java
 *
 * Created on March 9, 2005, 11:17 AM
 */

package pl.psnc.vlab.conf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.psnc.vlab.exception.VlabException;

/**
 * {@link SslFactory} class - abstract class is used for the ssl communication
 * initialisation
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class SslFactory {

	/** Instance of logger */
	private static Log log = LogFactory.getLog("pl.psnc.vlab.conf.SslFactory");

	/**
	 * Initialize the SSL with the values specified by the Configuration
	 * 
	 * @param config configuration object
	 * @throws pl.psnc.vlab.exception.VlabException
	 */
	public static final void initSsl(ClassLoader classLoader, IConfiguration config)
			throws VlabException {
		log.debug("<initSsl>");
		String dest = new StringBuffer().append(config.getSystemConfDir()).append("/").append(
				config.getKeyStore()).toString();

		copy(config.getKeyStore(), dest);

		log.debug("keystore=" + dest);
		System.setProperty("javax.net.ssl.keyStorePassword", config.getKeyStorePasswd());
		System.setProperty("javax.net.ssl.keyStore", dest);

		dest = new StringBuffer().append(config.getSystemConfDir()).append("/").append(
				config.getTrustStore()).toString();

		copy(config.getTrustStore(), dest);

		log.debug("truststore=" + dest);
		System.setProperty("javax.net.ssl.trustStorePassword", config.getTrustStorePasswd());
		System.setProperty("javax.net.ssl.trustStore", dest);
	}

	/**
	 * Copies the source file which is located in jar to the specified
	 * destination
	 * 
	 * @param source source file (resource in jar)
	 * @param dest destination path
	 */
	private static void copy(String source, String dest) throws VlabException {
		log.debug("Copy " + source + " to " + dest);
		FileOutputStream out = null;
		InputStream in = null;
		try {
			out = new FileOutputStream(new File(dest));
			in = SslFactory.class.getClassLoader().getResourceAsStream(source);
			int b;
			while ((b = in.read()) != -1) {
				out.write(b);
			}
		} catch (Exception e) {
			log.error("Copy:" + e.getMessage());
			throw new VlabException("Copy error. Details:" + e.getMessage(), e);
		} finally {
			try {
				if (in != null) {
					in.close();
				}
				if (out != null) {
					out.close();
				}
			} catch (Exception e) {
				throw new VlabException("Error closing stream. Details:" + e.getMessage(), e);
			}
		}// end of finally
	}
}
