/**
 * Created on Sep 3, 2008
 */
package pl.psnc.expres.remote.network.value;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * {@link NetworkMetricStatus} class - used by the EXPReS Network Module (ENM)
 * to provide information about preparation of network metric.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
@XmlAccessorType( XmlAccessType.PROPERTY) 
@XmlType(name="NetworkMetric", namespace="http://value.network.remote.expres.psnc.pl/", 
		propOrder={
		"progress", "descriptionKey"
})
public class NetworkMetricStatus {
	
	@XmlTransient
	/**Stores current progress of preparing network metric. Progress should be a
	 * number between 0 and 100. First 50% is regarding delay quering*/
	private int progress;
	/** Stores description key of the current status */
	private String descriptionKey;
	
	public NetworkMetricStatus(){
		
	}

	/**
	 * Get value of field: progress
	 * 
	 * @return the progress
	 */
	public int getProgress() {
		return progress;
	}

	/**
	 * Set value of field: progress
	 * 
	 * @param progress the progress to set
	 */
	public void setProgress(int progress) {
		this.progress = progress;
	}

	/**
	 * Get value of field: descriptionKey
	 * 
	 * @return the descriptionKey
	 */
	public String getDescriptionKey() {
		return descriptionKey;
	}

	/**
	 * Set value of field: descriptionKey
	 * 
	 * @param descriptionKey the descriptionKey to set
	 */
	public void setDescriptionKey(String descriptionKey) {
		this.descriptionKey = descriptionKey;
	}

}
