/**
 * Created on Sep 3, 2008
 */
package pl.psnc.expres.remote.network.value;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

/**
 * {@link NetworkMetric} class - class represents network metric for pair of
 * translation node and file server. All values not measured are set to -1
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
@XmlAccessorType( XmlAccessType.PROPERTY )
@XmlType(name="NetworkMetric", namespace="http://value.network.remote.expres.psnc.pl/", 
		propOrder={
		"translationNodeId", "fileServerId", "delay", "bandwidth",
		"loss"
})
public class NetworkMetric {
	
	/** Stores instance of field: translation node Id */
	private int translationNodeId;
	/** Stores instance of field: file server Id */
	private int fileServerId;
	/** Measured delay  */
	private double delay;
	/** Measured bandwidth*/
	private double bandwidth;
	/**Measured loss*/
	private double loss;
		
	public NetworkMetric() {
		this.translationNodeId = -1;
		this.fileServerId = -1;
		this.delay=-1.0;
		this.loss=-1.0;
		this.bandwidth=-1.0;
	}
	
	/**
	 * Creates a new instance of {@link NetworkMetric} with TN and FS
	 * identifiers defined.
	 * 
	 * @param translationNodeId translation node identifier
	 * @param fileServerId file server identifier
	 */
	public NetworkMetric(int translationNodeId, int fileServerId) {
		this.translationNodeId = translationNodeId;
		this.fileServerId = fileServerId;
	}

	/**
	 * Get value of field: translationNodeId
	 * 
	 * @return the translationNodeId
	 */
	public int getTranslationNodeId() {
		return translationNodeId;
	}

	/**
	 * Set value of field: translationNodeId
	 * 
	 * @param translationNodeId the translationNodeId to set
	 */
	public void setTranslationNodeId(int translationNodeId) {
		this.translationNodeId = translationNodeId;
	}

	/**
	 * Get value of field: fileServerId
	 * 
	 * @return the fileServerId
	 */
	public int getFileServerId() {
		return fileServerId;
	}

	/**
	 * Set value of field: fileServerId
	 * 
	 * @param fileServerId the fileServerId to set
	 */
	public void setFileServerId(int fileServerId) {
		this.fileServerId = fileServerId;
	}

	public void setDelay(double delay) {
		this.delay = delay;
	}

	public double getDelay() {
		return delay;
	}

	public void setBandwidth(double bandwidth) {
		this.bandwidth = bandwidth;
	}

	public double getBandwidth() {
		return bandwidth;
	}
	
	public double getLoss() {
		return loss;
	}

	public void setLoss(double loss) {
		this.loss = loss;
	}

}
