package pl.psnc.expres.remote.network.sessions;

import pl.psnc.expres.remote.network.task.MeasurementTask;

/**
 * Abstract class for session stage
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public abstract class SessionStage {
	
	public String getName (){
		return this.getClass().getName();
	}
	
	public void setSession(Session session) {
		this.session = session;
	}

	/**Related session*/
	private Session session;
	
	/** Identifies if stage is complate*/
	private boolean isComplete=false;
	
	/**
	 * Starts session stage
	 * @throws SessionExeception
	 */
	public abstract void start() throws SessionExeception;
	/**
	 * Updates session stage
	 * @param task
	 * @throws SessionExeception
	 */
	public abstract void update (MeasurementTask task, boolean complete) throws SessionExeception;
	/**
	 * Gets session stage progress 
	 * @return
	 */
	public abstract double progress();
	
	/**
	 * Gets session 
	 * @return related session
	 */
	public Session getSession() {
		return session;
	}
	/**
	 * Checks if session stage is complete
	 * @return
	 */
	public boolean isComplete(){
		return isComplete;
	}
	
	public void setComplete (boolean complete){
		isComplete= true;
	}
}
