package pl.psnc.expres.remote.network.sessions;

import pl.psnc.expres.remote.network.task.InvalidTaskTypeException;
import pl.psnc.expres.remote.network.task.MeasurementTask;

/**
 * Session listener interface
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public interface SessionObserver {
	/**
	 * Informs about session updates
	 * @param identifier session identifier
	 * @param sessionState current session state
	 */
	public void updateSessionState (int session, int sessionState);
	/**
	 * Informs about session complete
	 */
	public void sessionCompleted (int session);
	/**
	 * Requests session task
	 * 
	 * @param type					type of task
	 * @param startPointIdentifier	start point identifier
	 * @param endPointIdentifier	end point identifier
	 * @param sessionIdentifier		session identifier 
	 */
	public MeasurementTask requestSessionTask (String type, int startPointIdentifier, int endPointIdentifier, int session) throws InvalidTaskTypeException;

}
