package pl.psnc.expres.remote.network.sessions;

import java.util.ArrayList;
import java.util.List;

import pl.psnc.expres.remote.network.task.MeasurementTask;

/**
 * Express measurement session 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class MultiStageSession  extends Session{
	
	/**Session stages*/
	private List<SessionStage> stages= new ArrayList<SessionStage>();
	
	/**Current session stage*/
	private int currentStage=0;
	
	/**Number of session stages*/
	private int numberOfStages=0;
	
	private boolean sessionStarted=false;
	/** Session stage can be add only before session start*/
	 
	public void addSessionStage (SessionStage stage){
		if (!sessionStarted){
			stage.setSession (this);
			stages.add(stage);
			numberOfStages++;
		}
	}
	
	/**
	 * Starts session
	 */
	public void start () throws SessionExeception{
		if (stages == null)
			throw new SessionExeception("Multistage session has now defined stages");
		
		sessionStarted = true;
		currentStage = 0;
		SessionStage first = stages.get(currentStage);
		System.out.println ("Starting stage:"+first.getName());
		if (first== null)
			throw new SessionExeception ("Multistage session has no first stage");
		first.start();	
	}
	
	/**
	 * Update status of current session state with completed task 
	 * 
	 * @param task completed task
	 * @throws SessionExeception 
	 */
	public void update (MeasurementTask task, boolean complete) throws SessionExeception{
	     SessionStage stage = stages.get(currentStage);
	     if (stage == null)
	    	 return;
	     stage.update(task, complete);
	     if (stage.isComplete()){
	    	 System.out.println ("Starting complete:"+stage.getName());
	    	 currentStage++;
	    	 if (currentStage>=numberOfStages)
	    		 summarizeSession();
	    	 else{
	    		 stage = stages.get(currentStage);
	    		 System.out.println ("Starting stage:"+stage.getName());
	    		 if (stage == null)
	    			 throw new SessionExeception ("Multistage session stage is not defined");
	    		 stage.start();
	    	 }
	    		 
	     }
	     
	}
	public void dispose(){
		
	}
	/**
	 * Summarized the DELAY_QUERING state and 
	 */

	private void summarizeSession() {
		setComplete(true);
		System.out.println ("Sumarizing session");
	}	
	public int getProgress() {
		return currentStage*100/numberOfStages;
	}
}
