package pl.psnc.expres.remote.network.sessions;

import java.util.Comparator;

import pl.psnc.expres.remote.network.value.NetworkMetric;

/**
 * Compares the values of delays
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class DelayComparator implements Comparator<NetworkMetric>{

	public int compare(NetworkMetric o1, NetworkMetric o2) {
		double delay1 = o1.getDelay();
		double delay2 = o2.getDelay();
		
		if (delay1 != -1 && delay2 !=-1){
			if (delay1>delay2)
				return 1;
			if (delay1==delay2)
				return 0;
			if (delay1<delay2)
				return -1;
			
		}else{
			if (delay1== -1 && delay2==-1)
				return 0;
			if (delay1 != -1)
				return 1;
			if (delay2 !=-1)
				return -1;
		}
		return 0;
	}

}
