package pl.psnc.expres.remote.network.sessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import pl.psnc.expres.remote.network.task.InvalidTaskTypeException;
import pl.psnc.expres.remote.network.task.MeasurementTask;
import pl.psnc.expres.remote.network.value.NetworkMetric;


/**
 * Bandwidth quering session stage
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 */
public class BandwidthQueringSessionStage extends SessionStage {

	private volatile int numberOfCompletedTasks=0;
	private volatile int numberOfTasks=0;
	private String bandwidthQueringTaskName="bwctl";
	private List<NetworkMetric> metrics = Collections.synchronizedList(new ArrayList<NetworkMetric>());
	
	
	@Override
	public double progress() {
		return numberOfCompletedTasks/numberOfTasks;
	}

	@Override
	public void start() throws SessionExeception {
		List<NetworkMetric> sessionMetrics = super.getSession().getResult();
		for (NetworkMetric metric: sessionMetrics)
			metrics.add(metric);
		if (metrics.isEmpty()){
			int startPointslength = super.getSession().getStartPoints().size();
			int endPointslength = super.getSession().getEndPoints().size();
			NetworkMetric metric = null;
			
			for (int i=0;i<startPointslength;i++){
				for (int j=0;j<endPointslength;j++){
					metric = new NetworkMetric (getSession().getStartPoints().get(i), getSession().getEndPoints().get(j));
				}
			}
		}
		numberOfTasks =getSession().getStartPoints().size();
		numberOfCompletedTasks=0;
		if (metrics.isEmpty()){
			setComplete(true);
			return;
		}
		NetworkMetric metric = metrics.remove(0);
		try {
			getSession().getObserver().requestSessionTask(bandwidthQueringTaskName, metric.getTranslationNodeId(), metric.getFileServerId(), getSession().getIdentifier());
		} catch (InvalidTaskTypeException e) {
			Logger.getLogger("Invalid type of task");
			throw new SessionExeception (e);
		}
	}	

	@Override
	public void update(MeasurementTask task, boolean complete) throws SessionExeception {
		if (task==null)
			return;
		NetworkMetric oldMetric  = getSession().getNetworkMetric(task.getSource().getId(), task.getDestination().getId());
		if (complete){	
			Long bandwidth = (Long)task.getResult().get("sender-bandwidth");
			
			if (bandwidth == null){
				if (oldMetric != null)
					getSession().removeNetworkMetrics(oldMetric);
			}else	
			if (bandwidth.doubleValue()>= getSession().getBandwidth()){
				System.out.println (bandwidth.doubleValue()+":"+getSession().getBandwidth());
				Iterator<NetworkMetric> iterator = metrics.iterator();
				NetworkMetric  metric =null;
				List<NetworkMetric> toRemove = new ArrayList<NetworkMetric>();
				while (iterator.hasNext()){
					metric = iterator.next();
					if (metric != null && metric.getTranslationNodeId()==task.getSource().getId() && metric.getFileServerId()!= task.getDestination().getId())
						toRemove.add(metric);			
					}
				for (NetworkMetric m:toRemove ){
					metrics.remove(metric);
					getSession().removeNetworkMetrics(metric);
				}
				if (oldMetric != null){
					oldMetric.setBandwidth(bandwidth.doubleValue());
				}
			}else{
				System.out.println ("Za malo");
			}
		}else
		if (oldMetric!= null)
			getSession().removeNetworkMetrics(oldMetric);
		if (metrics.isEmpty()){
			setComplete(true);
			return;
		}
		NetworkMetric metric = metrics.remove(0);
		try {
			getSession().getObserver().requestSessionTask(bandwidthQueringTaskName, metric.getTranslationNodeId(), metric.getFileServerId(), getSession().getIdentifier());
		} catch (InvalidTaskTypeException e) {
			throw new SessionExeception (e);
		}
	}
	public String getBandwidthQueringTaskName() {
		return bandwidthQueringTaskName;
	}

	public void setBandwidthQueringTaskName(String bandwidthQueringTaskName) {
		this.bandwidthQueringTaskName = bandwidthQueringTaskName;
	}
}
